/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.dyeable_redstone_signal.common.block;

import com.hexagram2021.dyeable_redstone_signal.common.block.ColorfulRedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.RedstoneWireBlock;
import com.hexagram2021.dyeable_redstone_signal.common.block.entity.CommonRedstoneWireBlockEntity;
import com.hexagram2021.dyeable_redstone_signal.common.register.DRSBlocks;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CommonRedstoneWireBlock
extends RedstoneWireBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final Vec3[] COLORS = (Vec3[])Util.m_137469_((Object)new Vec3[16], vec3s -> {
        for (int i = 0; i <= 15; ++i) {
            double f;
            double f1 = f * 0.5 + ((f = (double)i / 15.0) > 0.0 ? 0.4 : 0.3);
            double f2 = Mth.m_14008_((double)(f * f * 0.7 - 0.35), (double)0.0, (double)1.0);
            double f3 = Mth.m_14008_((double)(f * f * 0.6 - 0.4), (double)0.0, (double)1.0);
            vec3s[i] = new Vec3(f1, f2, f3);
        }
    });

    public CommonRedstoneWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState defaultBlockStateWithPower(BlockState blockState) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWER, (Comparable)((Integer)blockState.m_61143_((Property)POWER)));
    }

    @Override
    public BlockState crossStateWithPower(BlockState blockState) {
        return (BlockState)super.crossStateWithPower(blockState).m_61124_((Property)POWER, (Comparable)((Integer)blockState.m_61143_((Property)POWER)));
    }

    @Override
    protected boolean canConnectWireWith(BlockState blockState) {
        return blockState.m_61138_((Property)ColorfulRedstoneWireBlock.POWER);
    }

    @Override
    protected BlockState getDefaultState() {
        return (BlockState)super.getDefaultState().m_61124_((Property)POWER, (Comparable)Integer.valueOf(0));
    }

    @Override
    protected void updatePowerStrength(Level level, BlockPos blockPos, BlockState blockState) {
        int[] signals = this.calculateTargetStrength(level, blockPos);
        boolean signal_changed = false;
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof CommonRedstoneWireBlockEntity) {
            CommonRedstoneWireBlockEntity commonRedstoneWireBlockEntity = (CommonRedstoneWireBlockEntity)blockEntity;
            for (int colorIndex = 0; colorIndex < CommonRedstoneWireBlockEntity.COLORS.length; ++colorIndex) {
                if (commonRedstoneWireBlockEntity.getColoredEnergy(colorIndex) == signals[colorIndex]) continue;
                signal_changed = true;
            }
            if (signal_changed) {
                commonRedstoneWireBlockEntity.setColoredEnergies(signals);
                if (level.m_8055_(blockPos) == blockState) {
                    level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(commonRedstoneWireBlockEntity.getMaxEnergy())), 2);
                }
                level.m_46672_(blockPos, (Block)this);
                for (Direction direction : Direction.values()) {
                    level.m_46672_(blockPos.m_121945_(direction), (Block)this);
                }
            }
        }
    }

    private int[] calculateTargetStrength(Level level, BlockPos blockPos) {
        int i = CommonRedstoneWireBlock.getBestNeighborSignal(level, blockPos);
        int[] signals = new int[CommonRedstoneWireBlockEntity.COLORS.length];
        for (int colorIndex = 0; colorIndex < CommonRedstoneWireBlockEntity.COLORS.length; ++colorIndex) {
            int j = 0;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = blockPos.m_121945_(direction);
                BlockEntity blockEntity = level.m_7702_(blockpos);
                BlockState blockState = level.m_8055_(blockpos);
                j = Math.max(j, CommonRedstoneWireBlock.getWireSignal(blockEntity, blockState, colorIndex, direction));
                BlockPos blockpos1 = blockPos.m_7494_();
                if (blockState.m_60796_((BlockGetter)level, blockpos) && !level.m_8055_(blockpos1).m_60796_((BlockGetter)level, blockpos1)) {
                    j = Math.max(j, CommonRedstoneWireBlock.getWireSignal(level.m_7702_(blockpos.m_7494_()), level.m_8055_(blockpos.m_7494_()), colorIndex, direction));
                    continue;
                }
                if (blockState.m_60796_((BlockGetter)level, blockpos)) continue;
                j = Math.max(j, CommonRedstoneWireBlock.getWireSignal(level.m_7702_(blockpos.m_7495_()), level.m_8055_(blockpos.m_7495_()), colorIndex, direction));
            }
            signals[colorIndex] = Math.max(i, j - 1);
        }
        return signals;
    }

    private static int getBestNeighborSignal(Level level, BlockPos blockPos) {
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockPos curBlockPos = blockPos.m_121945_(direction);
            BlockState blockState = level.m_8055_(curBlockPos);
            if (!blockState.m_60713_((Block)DRSBlocks.COMMON_REDSTONE_CONVERTER.get())) continue;
            int j = level.m_277185_(curBlockPos, direction);
            if (j >= 15) {
                return 15;
            }
            if (j <= i) continue;
            i = j;
        }
        return i;
    }

    public static int getColorForPower(int energy) {
        Vec3 vec3 = COLORS[energy];
        return Mth.m_14159_((float)((float)vec3.m_7096_()), (float)((float)vec3.m_7098_()), (float)((float)vec3.m_7094_()));
    }

    @Override
    public int getPower(BlockState blockState) {
        return (Integer)blockState.m_61143_((Property)POWER);
    }

    @Override
    protected BlockState setPowerFrom(BlockState blockState, BlockState source) {
        return (BlockState)blockState.m_61124_((Property)POWER, (Comparable)((Integer)source.m_61143_((Property)POWER)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{POWER});
    }

    @Override
    protected Vec3 getColor(int energy) {
        return COLORS[energy];
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new CommonRedstoneWireBlockEntity(blockPos, blockState);
    }
}

